<?php
date_default_timezone_set('America/New_York'); // Force local timezone
require __DIR__ . '/vendor/autoload.php';

use RingCentral\SDK\SDK;

function sendSMS($to, $message) {
    $clientId     = getenv('RC_CLIENT_ID');
    $clientSecret = getenv('RC_CLIENT_SECRET');
    $serverURL    = getenv('RC_SERVER_URL');   // e.g., https://platform.ringcentral.com
    $username     = getenv('RC_USERNAME');     // RingCentral phone #
    $extension    = getenv('RC_EXTENSION');    // often empty
    $password     = getenv('RC_PASSWORD');

    try {
        $rcsdk = new SDK($clientId, $clientSecret, $serverURL);
        $platform = $rcsdk->platform();
        $platform->login($username, $extension, $password);

        $platform->post('/restapi/v1.0/account/~/extension/~/sms', [
            'from' => ['phoneNumber' => $username],
            'to'   => [['phoneNumber' => $to]],
            'text' => $message
        ]);
        return true;
    } catch (Exception $e) {
        error_log("RingCentral SMS failed: " . $e->getMessage());
        return false;
    }
}