<?php
function generateApplePass($ticket) {
    $passData = [
        "formatVersion" => 1,
        "passTypeIdentifier" => "pass.com.yourdomain.parking",
        "serialNumber" => $ticket['id'],
        "teamIdentifier" => "YOUR_TEAM_ID",
        "organizationName" => "Guest Parking",
        "description" => "Parking Access Ticket",
        "foregroundColor" => "rgb(255,255,255)",
        "backgroundColor" => "rgb(28,28,30)",
        "labelColor" => "rgb(29,233,182)",
        "barcode" => [
            "format" => "PKBarcodeFormatQR",
            "message" => $ticket['id'],
            "messageEncoding" => "iso-8859-1"
        ],
        "generic" => [
            "primaryFields" => [[
                "key" => "plate",
                "label" => "LICENSE PLATE",
                "value" => $ticket['plate'] . " (" . $ticket['state'] . ")"
            ]],
            "secondaryFields" => [[
                "key" => "address",
                "label" => "VISITING",
                "value" => $ticket['address']
            ]],
            "auxiliaryFields" => [[
                "key" => "expires",
                "label" => "EXPIRES",
                "value" => $ticket['expiration_time']
            ]]
        ]
    ];

    $passDir = __DIR__ . "/../wallet/tmp/" . $ticket['id'];
    if (!is_dir($passDir)) mkdir($passDir, 0777, true);
    file_put_contents($passDir . "/pass.json", json_encode($passData));

    return $passDir . ".pkpass"; // Placeholder, needs Apple signing
}

function generateGooglePass($ticket) {
    $objectId = "guestparking.ticket." . $ticket['id'];

    $object = [
        "id" => $objectId,
        "classId" => "guestparking.ticket_class",
        "state" => "ACTIVE",
        "barcode" => [
            "type" => "QR_CODE",
            "value" => $ticket['id']
        ],
        "textModulesData" => [[
            "header" => "Parking Ticket",
            "body" => "Plate: " . $ticket['plate'] . "\nVisit: " . $ticket['address']
        ]],
        "linksModuleData" => [
            "uris" => [[
                "kind" => "walletobjects#uri",
                "uri" => "https://yourdomain.com/api/ticket?id=" . $ticket['id'],
                "description" => "View Ticket"
            ]]
        ]
    ];

    return "https://pay.google.com/gp/v/save/" . base64_encode(json_encode($object));
}