<?php
// /api/wallet/google.php
require __DIR__ . '/../config/db.php';

$ticketId = $_GET['id'] ?? null;
if (!$ticketId) {
    http_response_code(400);
    echo json_encode(["error" => "Missing ticket ID"]);
    exit;
}

// Fetch ticket details
$stmt = $pdo->prepare("SELECT * FROM parking_lots WHERE parking_lot_id = ? AND rec_deleted = 'n'");
$stmt->execute([$ticketId]);
$ticket = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ticket) {
    http_response_code(404);
    echo json_encode(["error" => "Ticket not found"]);
    exit;
}

// Normally: build JWT, sign with Google service account
// For now: return stub JSON
header('Content-Type: application/json');
echo json_encode([
    "status" => "stub",
    "message" => "Google Wallet generation requires service account setup",
    "ticket_id" => $ticketId,
    "plate" => $ticket['tag_number'],
    "state" => $ticket['stateProvidence']
]);